# LeadsGen Pro v1.0.0 - All-in-One Business Information Extractor

**The ultimate business data extraction tool** for extracting verified contacts, emails, and complete business profiles from multiple platforms.

---

## 📦 Installation

### Windows

1. **Extract the ZIP file** to your desired location
2. **Run `LeadsGenPro-Setup.exe`** to launch the application
3. **Activate your license** (you'll receive your license key via email after purchase)

### System Requirements
- **OS**: Windows 10/11 (64-bit)
- **RAM**: 4GB minimum, 8GB recommended
- **Storage**: 500MB free space
- **Internet**: Required for scraping and license validation

---

## 🚀 First Launch & License Activation

When you first run LeadsGen Pro, you'll be prompted to activate your license:

1. **Enter your license key** (format: LGPRO-XXXXX-XXXXX-XXXXX-XXXXX)
2. **Enter your email** (must match the purchase email)
3. Click **"Activate License"**

Your license will be validated with our servers. Once activated, you're ready to start scraping!

### License Information
- ✅ **30-day money-back guarantee** on all plans
- 🔄 **Automatic renewal** (unless you choose lifetime plan)
- 📧 **License key sent to email** within minutes of payment

---

## ✨ Key Features

### 11 Powerful Scrapers
Extract business data from:
- 🗺️ **Google Maps** - Complete business profiles with reviews
- 📒 **Yellow Pages** - Verified business listings
- 📋 **Super Pages** - Comprehensive business information
- 🔍 **DexKnows** - Local business directory
- ⭐ **Yelp** - Reviews, ratings, and business details
- 🏠 **Angi** (formerly Angie's List) - Service providers
- 📧 **Email & Phone Extractor** - Direct from websites
- 📱 **Spokeo Phone Numbers** - Phone number lookup
- 📸 **Instagram** - Business profiles and contact info
- 🏢 **Chamber of Commerce** - Local business networks
- 🔎 **Find Us Local** - Community business listings

### Advanced Features
- ✉️ **Email Enrichment** - Find missing emails for scraped businesses
- 🔧 **Proxy Support** (Optional) - Avoid rate limiting & IP blocks
- 📊 **Real-time Export** - Save data as you scrape (CSV/Excel)
- 🤖 **Telegram Notifications** (Optional) - Get updates on your phone
- 💬 **Discord Webhooks** (Optional) - Team notifications
- ⏸️ **Pause/Resume** - Campaign state management
- 🔄 **Anti-Bot Detection** - Undetected scraping with stealth mode

---

## 📖 How to Use

### Basic Workflow

1. **Select a scraper** from the left sidebar (e.g., "Google Maps")
2. **Enter your search criteria**:
   - Keywords (e.g., "plumbers", "restaurants")
   - Locations (e.g., "New York, NY", "Los Angeles, CA")
3. **Choose fields to extract** (Business Name, Phone, Email, etc.)
4. **Configure settings**:
   - Number of pages to scrape
   - Export format (CSV/Excel)
   - Wait times (to avoid detection)
5. **Click "Start Scraping"**
6. **Monitor progress** in real-time
7. **Export results** when complete

---

## 🗺️ Scraper Guides

### Google Maps Scraper

**Best for**: Local businesses with Google presence

**Steps**:
1. Navigate to **"Google Maps"** in the sidebar
2. Enter keywords (e.g., "coffee shops", "dentists")
3. Add locations (one per line, e.g., "Miami, FL")
4. Select pages to scrape (default: 3 pages = ~60 businesses)
5. Choose fields to extract
6. Click **"Start Scraping"**

**Extracted Data**:
- Business Name, Description
- Phone Number, Additional Phones
- Email Address
- Full Address
- Website
- Business Category
- Total Reviews & Rating
- Business Hours
- Price Range

---

### Yellow Pages Scraper

**Best for**: Verified US business listings

**Steps**:
1. Navigate to **"Yellow Pages"**
2. Enter business types (e.g., "attorneys", "contractors")
3. Add cities/states
4. Configure deep scraping (optional - visits each business page for more details)
5. Click **"Start Scraping"**

**Extracted Data**:
- Business Name, Phone, Email
- Full Address
- Website & Business Image
- Business Category
- Business Hours
- Years in Business
- Services & Payment Methods
- Rating & Review Count
- Social Media Links

---

### Email & Phone Extractor

**Best for**: Finding emails/phones from any website

**Steps**:
1. Navigate to **"Emails & Phones"**
2. Choose search engine (Google/Bing)
3. Enter keywords (e.g., "real estate agents Miami")
4. Select country
5. Configure email types to search for
6. Click **"Start Extraction"**

**Extracted Data**:
- Web Title & Description
- Phone Numbers
- Email Addresses
- Web Links

---

## ✉️ Email Enrichment

**Find missing emails for your scraped businesses!**

### How It Works

1. Navigate to **"📧 Email Enrichment"** in the sidebar
2. Click **"📁 Load from File"** and select your scraped data (CSV/XLSX)
3. Configure settings:
   - **Max Patterns to Test**: 5-15 (higher = more thorough)
   - **Use Browser Scraping**: ✅ Recommended (scrapes websites for emails)
4. Click **"🔍 Find Missing Emails"**
5. Wait for processing (shows progress bar)
6. Review results in the table
7. Click **"💾 Export Enriched Data"**

### Email Finding Methods

1. **Website Scraping** (Most Reliable):
   - Opens business websites
   - Searches contact pages, about pages, footer
   - Extracts visible email addresses
   - Confidence: 90-95%

2. **Pattern Generation**:
   - Generates common email patterns:
     - first@domain.com
     - first.last@domain.com
     - info@domain.com, contact@domain.com
   - Verifies using SMTP
   - Confidence: 50-80%

### Example Results

| Business Name | Original Email | Found Email | Confidence | Method |
|---------------|----------------|-------------|------------|--------|
| Joe's Plumbing | N/A | joe@joesplumbing.com | 95% | Website Scraping |
| ABC Law Firm | N/A | contact@abclaw.com | 90% | Website Scraping |
| Mike's Pizza | N/A | info@mikespizza.com | 70% | Pattern Generation |

---

## 🔧 Proxy Settings (Optional)

**Why use proxies?**
- Avoid rate limiting (scrape faster)
- Prevent IP blocks
- Distribute requests across multiple IPs
- Essential for large-scale scraping

### How to Set Up Proxies

1. Navigate to **"🔧 Proxy Settings"** in the sidebar

2. **Add Your Proxies**:
   - Paste proxy list (one per line) in the text area
   - Supported formats:
     ```
     IP:Port
     IP:Port:Username:Password
     User:Pass@IP:Port
     http://IP:Port
     http://user:pass@host:port
     ```
   - Or click **"📁 Import from File"** to load from .txt file

3. **Configure Settings**:
   - Connection Type: HTTP, HTTPS, SOCKS5
   - Rotation: Rotate every N requests (default: 1)

4. **Test Your Proxies**:
   - Click **"🧪 Test All Proxies"**
   - Wait for testing to complete
   - View results: ✅ Live, ❌ Dead, ⚪ Unknown
   - Click **"🗑️ Remove Dead Proxies"** to clean up

5. **Enable Proxies**:
   - ✅ Check **"Enable Proxy (Apply to all scrapers)"**
   - Click **"💾 Save Proxy Settings"**

6. **Start Scraping** - Proxies will now be used automatically!

### Where to Get Proxies

- **Residential Proxies** (Best for avoiding blocks):
  - Bright Data, Smartproxy, Oxylabs
- **Datacenter Proxies** (Faster, cheaper):
  - Webshare, ProxyRack, IPRoyal
- **Free Proxies** (Not recommended - slow & unreliable)

**Note**: Proxy use is completely optional. The software works fine without proxies for moderate scraping.

---

## 🤖 Telegram Notifications (Optional)

Get real-time updates on your phone!

### Setup Steps

1. **Create a Telegram Bot**:
   - Open Telegram and search for **@BotFather**
   - Send `/newbot`
   - Follow prompts to create your bot
   - Copy the **Bot Token** (format: 1234567890:ABCdefGHIjklMNOpqrsTUVwxyz)

2. **Get Your Chat ID**:
   - Search for your bot in Telegram
   - Send any message to your bot
   - Open: `https://api.telegram.org/bot<YOUR_BOT_TOKEN>/getUpdates`
   - Copy the `"chat":{"id":123456789}` number

3. **Configure in LeadsGen Pro**:
   - Navigate to **"Settings"** in the sidebar
   - Scroll to **"Telegram Notifications"**
   - Paste your Bot Token
   - Paste your Chat ID
   - ✅ Enable Telegram Notifications
   - Click **"Test Telegram Connection"**
   - Click **"💾 Save Settings"**

### What You'll Receive

- 🚀 **Campaign Started**: "Started scraping 3 keywords in 2 locations"
- 📊 **Progress Updates**: "Scraped 50/200 businesses (25%)"
- ✅ **Campaign Completed**: "Completed! Found 187 businesses. File: results.xlsx"
- ⚠️ **CAPTCHA Alerts**: "CAPTCHA detected! Please solve manually"
- ❌ **Errors**: "Error on page 3: Connection timeout"
- ✉️ **Email Enrichment**: "Found 42 emails for 100 businesses"

---

## 💬 Discord Notifications (Optional)

Send updates to your Discord server!

### Setup Steps

1. **Create a Webhook in Discord**:
   - Open your Discord server
   - Go to **Server Settings** → **Integrations** → **Webhooks**
   - Click **"New Webhook"**
   - Name it "LeadsGen Pro Bot"
   - Select the channel for notifications
   - Click **"Copy Webhook URL"**

2. **Configure in LeadsGen Pro**:
   - Navigate to **"Settings"** → **Bot Settings**
   - Scroll to **"Discord Notifications"**
   - Paste your Webhook URL
   - ✅ Enable Discord Notifications
   - Click **"Test Discord Connection"**
   - Click **"💾 Save Settings"**

### What You'll Receive

Same notifications as Telegram, beautifully formatted with Discord embeds.

---

## ⚙️ Settings & Configuration

### General Settings

**Browser Selection**:
- **Undetected Chrome** (Recommended) - Best anti-detection
- Chrome, Firefox, Playwright - Alternative browsers

**Anti-Robot Mode**:
- ✅ **Enabled** (Recommended) - Adds human-like delays and behavior
- ❌ Disabled - Faster but higher detection risk

**Timing Settings**:
- **Wait After Business**: 0-5 seconds (delay between businesses)
- **Batch Wait**: 3-10 seconds (delay after every N businesses)
- **Batch Size**: 10-20 businesses (scrape N businesses before pausing)

**Page Load Timeout**: 60 seconds (how long to wait for pages to load)

---

## 📊 Export & Results

### Export Formats

- **Excel (.xlsx)** - Recommended (preserves formatting, supports large datasets)
- **CSV (.csv)** - For importing into other tools

### Export Location

Results are saved to:
```
C:\Users\YourName\Documents\LeadsGenPro\exports\
```

### Real-Time Saving

Data is automatically saved during scraping to prevent loss:
```
exports\temp\{scraper}_{timestamp}.xlsx
```

When scraping completes, file is moved to:
```
exports\{scraper}_{timestamp}_final.xlsx
```

---

## 🔍 Campaign History

View all your past campaigns:

1. Navigate to **"Campaign History"** in the sidebar
2. See all campaigns with:
   - Scraper used
   - Keywords & locations
   - Number of results
   - Date & time
   - Status (Completed/Failed)
3. Click **"📂 Open Export"** to view results
4. Click **"📊 View Details"** for more information

---

## 🛠️ Troubleshooting

### License Issues

**"Invalid license key"**
- ✅ Check for typos in the license key
- ✅ Ensure email matches purchase email
- ✅ Wait 5 minutes after purchase for activation
- ✅ Contact support: support@leadsgen-pro.shop

**"License expired"**
- ✅ Check your subscription status
- ✅ Renew your license at leadsgen-pro.shop
- ✅ Contact support for assistance

### Scraping Issues

**"No results found"**
- ✅ Check your keywords (be specific, e.g., "plumbers" not "plumb")
- ✅ Verify location format (City, State or ZIP code)
- ✅ Try different scraper (Google Maps vs Yellow Pages)
- ✅ Reduce pages to scrape (start with 1-2 pages)

**"CAPTCHA detected"**
- ✅ Solve the CAPTCHA manually (browser window will stay open)
- ✅ Enable **Proxy Settings** to rotate IPs
- ✅ Increase **Wait Times** in settings
- ✅ Use **Anti-Robot Mode**

**"Connection timeout"**
- ✅ Check your internet connection
- ✅ Increase **Page Load Timeout** in settings (60-120 seconds)
- ✅ Try again later (site may be down)

**"Browser won't open"**
- ✅ Install Google Chrome (required for Undetected Chrome mode)
- ✅ Update Chrome to latest version
- ✅ Try different browser in settings (Firefox/Playwright)

### Email Enrichment Issues

**"No emails found"**
- ✅ Ensure businesses have valid websites
- ✅ Enable **"Use Browser Scraping"** (more effective)
- ✅ Increase **Max Patterns to Test** (10-15)
- ✅ Some businesses simply don't have public emails

**"Browser scraping is slow"**
- ✅ This is normal - it visits each website
- ✅ Disable browser scraping for faster (but less effective) results
- ✅ Use proxies to speed up if getting rate limited

### Proxy Issues

**"Proxy connection failed"**
- ✅ Test your proxies using **"🧪 Test All Proxies"**
- ✅ Remove dead proxies
- ✅ Verify proxy format is correct
- ✅ Check proxy provider dashboard for issues

**"All proxies dead"**
- ✅ Contact your proxy provider
- ✅ Verify proxy subscription is active
- ✅ Try different proxy provider

---

## 💡 Tips & Best Practices

### For Best Results

1. **Start Small**: Test with 1-2 pages before running large campaigns
2. **Use Specific Keywords**: "Italian restaurants" > "restaurants"
3. **Enable Anti-Robot Mode**: Reduces detection risk
4. **Use Proxies for Large Campaigns**: 100+ businesses
5. **Enrich Emails Separately**: Scrape first, then enrich in batches
6. **Monitor Progress**: Watch for CAPTCHAs and errors
7. **Save Frequently**: Enable real-time saving
8. **Test Proxies Before Use**: Remove dead ones immediately

### Optimal Settings

**For Small Campaigns (<100 businesses)**:
- Proxies: ❌ Not needed
- Wait After Business: 0-1 seconds
- Batch Size: 10-15
- Anti-Robot Mode: ✅ Enabled

**For Large Campaigns (100-1000 businesses)**:
- Proxies: ✅ Highly recommended
- Proxy Rotation: Every 1-2 requests
- Wait After Business: 2-3 seconds
- Batch Size: 20
- Batch Wait: 5-10 seconds
- Anti-Robot Mode: ✅ Enabled

**For Massive Campaigns (1000+ businesses)**:
- Proxies: ✅ Required (residential preferred)
- Proxy Rotation: Every 1 request
- Wait After Business: 3-5 seconds
- Batch Size: 15-20
- Batch Wait: 10-15 seconds
- Anti-Robot Mode: ✅ Enabled
- Split into multiple smaller campaigns

---

## 📞 Support & Contact

### Email Support
📧 **support@leadsgen-pro.shop**
- Response time: Within 24 hours
- Available: 24/7

### Telegram Support
💬 **@rootbck**
- Direct chat support
- Faster response times
- Available: Business hours

### Documentation
📚 **leadsgen-pro.shop/docs**
- Video tutorials
- FAQ
- Advanced guides

### Feature Requests
Have an idea? Email us at support@leadsgen-pro.shop with "Feature Request" in the subject line.

---

## 📝 License & Terms

- ✅ **30-day money-back guarantee** on all plans
- ✅ **Lifetime updates** (on lifetime plan)
- ✅ **Priority support** (on premium plans)
- ❌ **No refund after 30 days**
- ❌ **No sharing** - License is per-user
- ❌ **No commercial reselling** of scraped data without permission

Full terms: https://leadsgen-pro.shop/terms

---

## 🎉 Thank You!

Thank you for choosing **LeadsGen Pro**! We're committed to providing the best business data extraction tool on the market.

If you love the software, please:
- ⭐ Leave a review
- 📣 Recommend to colleagues
- 💬 Share feedback for improvements

Happy scraping! 🚀

---

**LeadsGen Pro v1.0.0**
© 2025 LeadsGen Pro. All rights reserved.
https://www.leadsgen-pro.shop
